import inspect

def static_counter():
    if not hasattr(static_counter, "counter"):
        setattr(static_counter,"counter",0)
    
    setattr(static_counter,"counter",getattr(static_counter,'counter')+1)
    return getattr(static_counter,"counter")


# static function executor
async def static_run(func,*args):
    name=func.__name__
    if not hasattr(static_run, name):
        setattr(static_run,name,False)
    if getattr(static_run,name) == False:
        if inspect.iscoroutinefunction(func):
            out=await func(*args)
        else:
            out=func(*args)
        setattr(static_run,name,True)

def static_boolen(name,*args):
    if not hasattr(static_boolen, name):
        setattr(static_boolen, name,False)
    if len(args)>0:
        setattr(static_boolen, name,args[0])
    return getattr(static_boolen, name)

